/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.utils;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.contentAssist.ContentAssistCollectors;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ElementsIndexingUtils;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public final class TypeHierarchyUtils {
    private static final int MAX_ANCESTORS_LIMIT = 20;

    public static List<IElementEntry> getClassAncestors(IModule module, String className, IElementsIndex index, String namespace, Map<String, String> aliases) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        List<IElementEntry> classEntries = index.getEntries(1, className);
        for (IElementEntry classEntry : classEntries) {
            if (module != null && !classEntry.getModule().equals(module)) continue;
            TypeHierarchyUtils.findClassAncestorsRecursivelly(classEntry, result, index, namespace, aliases);
        }
        return result;
    }

    public static List<IElementEntry> getDirectClassAncestors(IModule module, String className, IElementsIndex index) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        List<IElementEntry> classEntries = index.getEntries(1, className);
        for (IElementEntry classEntry : classEntries) {
            if (module != null && !classEntry.getModule().equals(module)) continue;
            TypeHierarchyUtils.findClassAncestors(classEntry, result, index);
        }
        return result;
    }

    public static List<IElementEntry> getDirectClassDescendants(IModule module, String className, IElementsIndex index) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        List<IElementEntry> classEntries = index.getEntries(1, className);
        for (IElementEntry classEntry : classEntries) {
            if (module != null && !classEntry.getModule().equals(module)) continue;
            TypeHierarchyUtils.findClassDescendants(classEntry, result, index);
        }
        return result;
    }

    public static List<IElementEntry> getClassDescendants(IModule module, String className, IElementsIndex index, String namespace, Map<String, String> aliases) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        List<IElementEntry> classEntries = index.getEntries(1, className);
        for (IElementEntry classEntry : classEntries) {
            if (module != null && !classEntry.getModule().equals(module)) continue;
            TypeHierarchyUtils.findClassDescendantsRecursivelly(classEntry, result, index, namespace, aliases);
        }
        return result;
    }

    public static Set<String> addAllAncestors(Set<String> types, IElementsIndex index, String namespace, Map<String, String> aliases) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String type : types) {
            result.add(type);
            List<IElementEntry> entries = TypeHierarchyUtils.getClassAncestors(null, type, index, namespace, aliases);
            for (IElementEntry entry : entries) {
                result.add(ElementsIndexingUtils.getFirstNameInPath(entry.getEntryPath()));
            }
        }
        return result;
    }

    public static List<IElementEntry> getClasses(IModule module, String className, IElementsIndex index) {
        List<IElementEntry> classEntries = index.getEntries(1, className);
        return classEntries;
    }

    public static List<IElementEntry> filterByBuildPath(IModule module, List<IElementEntry> toFilter) {
        IBuildPath buildPath = module.getBuildPath();
        return TypeHierarchyUtils.filterByBuildPath(buildPath, toFilter);
    }

    public static boolean isOnBuildPath(IModule module, IElementEntry entry) {
        IBuildPath buildPath = module.getBuildPath();
        return TypeHierarchyUtils.isOnBuildPath(buildPath, entry);
    }

    public static boolean isOnBuildPath(IBuildPath buildPath, IElementEntry entry) {
        IBuildPath currentEntryBuildPath = entry.getModule().getBuildPath();
        Set dependencies = buildPath.getDependencies();
        return buildPath.equals(currentEntryBuildPath) || dependencies.contains(entry.getModule().getBuildPath());
    }

    public static List<IElementEntry> filterByBuildPath(IBuildPath buildPath, List<IElementEntry> toFilter) {
        ArrayList<IElementEntry> result = new ArrayList<IElementEntry>();
        Set dependencies = buildPath != null ? buildPath.getDependencies() : new HashSet(1);
        for (IElementEntry entry : toFilter) {
            IModule module = entry.getModule();
            if (module == null) {
                if (!PHPBuiltins.getInstance().isBuiltinClassOrConstant(entry.getEntryPath())) continue;
                result.add(entry);
                continue;
            }
            IBuildPath currentEntryBuildPath = module.getBuildPath();
            if (!buildPath.equals(currentEntryBuildPath) && !dependencies.contains(currentEntryBuildPath)) continue;
            result.add(entry);
        }
        return result;
    }

    public static boolean isInNamespace(AbstractPHPEntryValue value, String namespace) {
        if (value == null) {
            return false;
        }
        String valueNamespace = value.getNameSpace();
        if (valueNamespace == null || valueNamespace.length() == 0) {
            return namespace == null || namespace.length() == 0 || "\\".equals(namespace);
        }
        return valueNamespace.equals(namespace);
    }

    public static boolean isInNamespace(AbstractPHPEntryValue value, Set<String> namespaces) {
        if (value == null) {
            return false;
        }
        String valueNamespace = value.getNameSpace();
        if (valueNamespace == null || valueNamespace.length() == 0) {
            return namespaces == null || namespaces.isEmpty() || namespaces.contains("\\");
        }
        return namespaces != null && namespaces.contains(valueNamespace);
    }

    public static boolean isInAliases(String entryPath, Map<String, String> aliases) {
        if (entryPath == null) {
            return false;
        }
        return aliases.containsKey(entryPath) || aliases.containsValue(entryPath);
    }

    private static void findClassAncestorsRecursivelly(IElementEntry classEntry, List<IElementEntry> toFill, IElementsIndex index, String namespace, Map<String, String> aliases) {
        List<String> traits;
        List<IElementEntry> classEntries;
        List<String> interfaces;
        if (toFill.size() > 20) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Max ancestors reached. Hierarchy lookup stopped. Please check your class hierarchy", (String)"com.aptana.editor.php/debug");
            return;
        }
        Object value = classEntry.getValue();
        if (!(value instanceof ClassPHPEntryValue)) {
            return;
        }
        ClassPHPEntryValue entryValue = (ClassPHPEntryValue)value;
        String superClassName = entryValue.getSuperClassname();
        IBuildPath classEntryBuildPath = null;
        if (classEntry.getModule() != null) {
            classEntryBuildPath = classEntry.getModule().getBuildPath();
        }
        if (superClassName != null) {
            List<IElementEntry> classEntries2;
            boolean aliasReplacement = false;
            if (aliases != null && aliases.containsKey(superClassName)) {
                superClassName = aliases.get(superClassName);
                aliasReplacement = true;
            }
            if (superClassName.startsWith("\\")) {
                superClassName = superClassName.substring(1);
            }
            if ((classEntries2 = index.getEntries(1, superClassName)).isEmpty()) {
                HashSet superClass = new HashSet(1);
                superClass.add(superClassName);
                Set<IElementEntry> entries = ContentAssistCollectors.collectBuiltinTypeEntries(superClass, true);
                classEntries2.addAll(entries);
            }
            TypeHierarchyUtils.collectAncestors(toFill, index, namespace, classEntryBuildPath, aliasReplacement, classEntries2);
        }
        if (!CollectionsUtil.isEmpty(interfaces = entryValue.getInterfaces())) {
            for (String interfaceName : interfaces) {
                boolean aliasReplacement = false;
                if (aliases != null && aliases.containsKey(interfaceName)) {
                    interfaceName = aliases.get(interfaceName);
                    aliasReplacement = true;
                }
                if (interfaceName.startsWith("\\")) {
                    interfaceName = interfaceName.substring(1);
                }
                classEntries = index.getEntries(1, interfaceName);
                TypeHierarchyUtils.collectAncestors(toFill, index, namespace, classEntryBuildPath, aliasReplacement, classEntries);
            }
        }
        if (!CollectionsUtil.isEmpty(traits = entryValue.getTraits())) {
            for (String trait : traits) {
                if (trait.startsWith("\\")) {
                    trait = trait.substring(1);
                }
                classEntries = index.getEntries(1, trait);
                TypeHierarchyUtils.collectAncestors(toFill, index, namespace, classEntryBuildPath, false, classEntries);
            }
        }
    }

    private static void collectAncestors(List<IElementEntry> toFill, IElementsIndex index, String namespace, IBuildPath classEntryBuildPath, boolean aliasReplacement, List<IElementEntry> entries) {
        List<IElementEntry> classEntriesOnBuildPath = TypeHierarchyUtils.filterByBuildPath(classEntryBuildPath, entries);
        for (IElementEntry entry : classEntriesOnBuildPath) {
            Object eValue = entry.getValue();
            if (!(eValue instanceof AbstractPHPEntryValue) || !aliasReplacement && !TypeHierarchyUtils.isInNamespace((AbstractPHPEntryValue)eValue, namespace)) continue;
            toFill.add(entry);
            TypeHierarchyUtils.findClassAncestorsRecursivelly(entry, toFill, index, namespace, null);
        }
    }

    private static void findClassAncestors(IElementEntry classEntry, List<IElementEntry> toFill, IElementsIndex index) {
        List<String> interfaces;
        Object value = classEntry.getValue();
        if (!(value instanceof ClassPHPEntryValue)) {
            return;
        }
        ClassPHPEntryValue entryValue = (ClassPHPEntryValue)value;
        IBuildPath classEntryBuildPath = classEntry.getModule().getBuildPath();
        String superClassName = entryValue.getSuperClassname();
        if (superClassName != null) {
            if (superClassName.startsWith("\\")) {
                superClassName = superClassName.substring(1);
            }
            List<IElementEntry> classEntries = index.getEntries(1, superClassName);
            List<IElementEntry> classEntriesOnBuildPath = TypeHierarchyUtils.filterByBuildPath(classEntryBuildPath, classEntries);
            toFill.addAll(classEntriesOnBuildPath);
        }
        if ((interfaces = entryValue.getInterfaces()) != null && !interfaces.isEmpty()) {
            for (String className : interfaces) {
                if (className.startsWith("\\")) {
                    className = className.substring(1);
                }
                List<IElementEntry> classEntries = index.getEntries(1, className);
                List<IElementEntry> classEntriesOnBuildPath = TypeHierarchyUtils.filterByBuildPath(classEntryBuildPath, classEntries);
                toFill.addAll(classEntriesOnBuildPath);
            }
        }
    }

    private static void findClassDescendants(IElementEntry classEntry, List<IElementEntry> result, IElementsIndex index) {
        List<IElementEntry> typeEntries = index.getEntriesStartingWith(1, "");
        IBuildPath classEntryBuildPath = classEntry.getModule().getBuildPath();
        String typeName = ElementsIndexingUtils.getLastNameInPath(classEntry.getEntryPath());
        if (EntryUtils.isInterface(classEntry)) {
            for (IElementEntry typeEntry : typeEntries) {
                ClassPHPEntryValue value = (ClassPHPEntryValue)typeEntry.getValue();
                List<String> interfaceNames = value.getInterfaces();
                if (interfaceNames == null || interfaceNames.size() == 0) continue;
                for (String interfaceName : interfaceNames) {
                    if (!typeName.equals(interfaceName) || !TypeHierarchyUtils.isOnBuildPath(classEntryBuildPath, typeEntry)) continue;
                    result.add(typeEntry);
                }
            }
        } else {
            for (IElementEntry typeEntry : typeEntries) {
                ClassPHPEntryValue value = (ClassPHPEntryValue)typeEntry.getValue();
                String currentSuperClassName = value.getSuperClassname();
                if (currentSuperClassName == null || !typeName.equals(currentSuperClassName) || !TypeHierarchyUtils.isOnBuildPath(classEntryBuildPath, typeEntry)) continue;
                result.add(typeEntry);
            }
        }
    }

    private static void findClassDescendantsRecursivelly(IElementEntry classEntry, List<IElementEntry> result, IElementsIndex index, String namespace, Map<String, String> aliases) {
        List<IElementEntry> typeEntries = index.getEntriesStartingWith(1, "");
        IBuildPath classEntryBuildPath = classEntry.getModule().getBuildPath();
        String typeName = ElementsIndexingUtils.getLastNameInPath(classEntry.getEntryPath());
        if (EntryUtils.isInterface(classEntry)) {
            for (IElementEntry typeEntry : typeEntries) {
                ClassPHPEntryValue value = (ClassPHPEntryValue)typeEntry.getValue();
                List<String> interfaceNames = value.getInterfaces();
                if (interfaceNames == null || interfaceNames.size() == 0) continue;
                for (String interfaceName : interfaceNames) {
                    if (!typeName.equals(interfaceName) || !TypeHierarchyUtils.isOnBuildPath(classEntryBuildPath, typeEntry)) continue;
                    result.add(typeEntry);
                    TypeHierarchyUtils.findClassAncestorsRecursivelly(typeEntry, result, index, namespace, aliases);
                }
            }
        } else {
            for (IElementEntry typeEntry : typeEntries) {
                ClassPHPEntryValue value = (ClassPHPEntryValue)typeEntry.getValue();
                String currentSuperClassName = value.getSuperClassname();
                if (currentSuperClassName == null || !typeName.equals(currentSuperClassName) || !TypeHierarchyUtils.isOnBuildPath(classEntryBuildPath, typeEntry)) continue;
                result.add(typeEntry);
                TypeHierarchyUtils.findClassAncestorsRecursivelly(typeEntry, result, index, namespace, aliases);
            }
        }
    }

    private TypeHierarchyUtils() {
    }
}

